
//sValidation=nyfjs
//sCaption=Export html tree ...
//sHint=Export content as webpages and make into HTML tree
//sCategory=MainMenu.Share
//sLocaleID=p.ExportHtmlTree
//sAppVerMin=6.1.2
//sShortcutKey=

var _lc=function(sTag, sDef){return plugin.getLocaleMsg(sTag, sDef);};
var _lc2=function(sTag, sDef){return _lc(plugin.getLocaleID()+'.'+sTag, sDef);};

var _trim=function(s){return (s||'').replace(/^\s+|\s+$/g, '');};
var _trim_l=function(s){return (s||'').replace(/^\s+/g, '');};
var _trim_r=function(s){return (s||'').replace(/\s+$/g, '');};
var _trim_cr=function(s){return (s||'').replace(/\r+$/g, '');};

var _html_encode=function(s)
{
	//http://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references
	s=s.replace(/&/g,	'&amp;');
	s=s.replace(/</g,	'&lt;');
	s=s.replace(/>/g,	'&gt;');
	s=s.replace(/\"/g,	'&quot;');
	s=s.replace(/\'/g,	'&apos;');
	s=s.replace(/  /g,	' &nbsp;'); //&nbsp; = non-breaking space;
	//and more ...
	return s;
};

var _html_decode=function(s)
{
	s=s.replace(/&lt;/g,		'<');
	s=s.replace(/&gt;/g,		'>');
	s=s.replace(/&quot;/g,		'"');
	s=s.replace(/&apos;/g,		'\'');
	s=s.replace(/&nbsp;/g,		' ');
	s=s.replace(/&circ;/g,		'^');
	s=s.replace(/&tilde;/g,		'~');
	//and more ...
	s=s.replace(/&amp;/g,		'&');
	return s;
};

try{

	var xNyf=new CNyfDb(-1);
	if(xNyf.isOpen()){

		var vActs=[
				  _lc2('CurBranch', '1. Export the current branch as HTML Tree')
				, _lc2('WholeDb', '2. Export the whole database as HTML Tree')
			];

		var sCfgKey='ExportHtmlTree.iAction';
		var sMsg=_lc('p.Common.SelAction', 'Please select an action form within the dropdown list');
		var iSel=dropdown(sMsg, vActs, localStorage.getItem(sCfgKey));
		if(iSel>=0){

			localStorage.setItem(sCfgKey, iSel);

			sCfgKey='ExportHtmlTree.sPathDst';
			var sDstDir=platform.browseForFolder(_lc2('SelDest', 'Select a destination folder to store the HTML tree'), localStorage.getItem(sCfgKey));
			if(sDstDir){

				localStorage.setItem(sCfgKey, sDstDir);

				var bCurBranch=(iSel==0);
				var sCurItem=bCurBranch ? plugin.getCurInfoItem(-1) : plugin.getDefRootContainer();
				var sTitle=bCurBranch ? xNyf.getFolderHint(sCurItem) : xNyf.getDbTitle();

				{
					//copy static files to the destination folder;
					var xNames={
						'jquery.js': 'jquery-1.5.min.js'
						, 'index.html': '_htmltree_index.html'
						, 'nav.html': '_htmltree_navpane.html'
						, 'itemlink.js': '_htmltree_itemlink.html' //2013.3.27 handle item links nyf://entry?...
						, 'icon_plus.gif': 'icon_plus.gif'
						, 'icon_minus.gif': 'icon_minus.gif'
						, 'icon_itemlink.gif': 'icon_itemlink.gif'
						, 'icon_attachment.gif': 'icon_attachment.gif'
						, 'icon_newwin.gif': 'icon_newwin.gif'
						, 'icon_jump.gif': 'icon_jump.gif'
						, 'icon_email.gif': 'icon_email.gif'
					};
					var sPathSrc=new CLocalFile(plugin.getScriptFile()).getDirectory();
					for(var sFn in xNames){
						var sNameDst=xNames[sFn];
						var xSrc=new CLocalFile(sPathSrc); xSrc.append(sNameDst);
						var xDst=new CLocalFile(sDstDir); xDst.append(sFn);
						if('.gif;.jpg;.png'.split(';').indexOf(xSrc.getExtension())>=0){
							xSrc.copyTo(sDstDir, sNameDst, false);
						}else{
							var s=xSrc.loadText();
							if(xSrc.getExtension().toLowerCase()=='.html'){
								s=s.replace(/%DbTitle%/g, sTitle);
							}
							xDst.saveUtf8(s);
						}
					}
				}

				var _validate_filename=function(s){
					s=s||'';
					s=s.replace(/[\*\?\.\(\)\[\]\{\}\<\>\\\/\!\$\^\&\+\|,;:\"\'`~@#]/g, ' ');
					s=s.replace(/\s{2,}/g, ' ');
					s=_trim(s);
					if(s.length>64) s=s.substr(0, 64);
					s=_trim(s);
					s=s.replace(/\s/g, '_');
					return s;
				};

				var _unique_filename=function(sDir, sName, sExt){
					var sRes=sName+sExt, xFn=new CLocalFile(sDir); xFn.append(sRes);
					while(xFn.exists()){
						sRes=sName+'-'+Math.round(Math.random()*1000)+sExt;
						xFn=new CLocalFile(sDir); xFn.append(sRes);
					}
					return sRes;
				};

				/*var _hash_name=function(s1, s2, sExt){
					//2011.2.8 make signed into unsigned by using the operator 'n>>>0';
					//http://hi.baidu.com/ebiyuan/blog/item/d0691adb9c78156ed1164e4b.html
					var sName=(adler32(s1)>>>0).toString(16).toLowerCase();
					if(s2) sName+='_'+(adler32(s2)>>>0).toString(16).toLowerCase();
					return sName+sExt;
				};*/

				var _xNamesUsed={};
				var _hash_name=function(s1, s2, sExt){
					var sName='', i=0;
					do{
						//2011.2.8 make signed into unsigned by using the operator 'n>>>0';
						//http://hi.baidu.com/ebiyuan/blog/item/d0691adb9c78156ed1164e4b.html
						sName=(adler32(s1)>>>0).toString(16).toLowerCase();
						if(s2) sName+='_'+(adler32(s2)>>>0).toString(16).toLowerCase();
						sName+=('_'+i);
						sName+=sExt;
						i++;
					}while(_xNamesUsed[sName]);
					//2013.11.2 save the name to avoid file overwriting;
					_xNamesUsed[sName]=1;
					return sName;
				};

				var _default_name=function(vFiles, bWebOnly){
					var sDef='';
					{
						var vDefNames=[sDefNoteFn, 'index.html', 'index.htm', 'home.html', 'home.htm', 'default.html', 'default.htm'];
						for(var i in vDefNames){
							if(i==0 && bWebOnly) continue;
							var sName=vDefNames[i];
							if((vFiles||[]).indexOf(sName)>=0){
								sDef=sName;
								break;
							}
						}
					}

					if(!sDef){
						var vBands='.html;.htm;.url>.xml;.eml>.gif;.png;.jpg;.jpeg;.bmp'.split('>');
						for(var j in vBands){
							var vExts=vBands[j].split(';');
							for(var i in vFiles){
								var sName=vFiles[i];
								var sExt=new CLocalFile(sName).getExtension().toLowerCase();
								if(vExts.indexOf(sExt)>=0){
									sDef=sName;
									break;
								}
							}
							if(sDef) break;
						}
					}
					return sDef;
				};

				var _updated=function(sSsgFn, sWinFn){
					var xWinFn=new CLocalFile(sWinFn), t1=xNyf.getModifyTime(sSsgFn), bUpd=true;
					if(xWinFn.exists()){
						var t2=xWinFn.getModifyTime();
						bUpd=t1>t2;
					}
					return bUpd;
				}

				plugin.initProgressRange(plugin.getScriptTitle());

				var sCss='table{border: 1px solid gray;} td{border: 1px dotted gray;} '
					+ 'p{margin: 3px 0 3px 0; padding: 0;} '
					+ '#ID_Footer{font-size: small; font-style: italic;} '
					+ 'a{padding-right: 20px; background: URL(./icon_newwin.gif) no-repeat center right;} '
					+ 'a[href ^= "mailto:"]{padding: 0 20px 0 0; background: URL(./icon_email.gif) no-repeat center right;} '
					+ 'a[href ^= "nyf:"]{padding: 0 20px 0 0; background: URL(./icon_jump.gif) no-repeat center right;} '
					;

				var sDefNoteFn=plugin.getDefNoteFn();

				//2013.3.27 enable item links to work;
				var xIDofPath={}, xPathOfID={}, xIDofDoc={};
				{
					var vLines=plugin.listItemIDs(-1).split('\r\n');
					for(var i in vLines){
						var v=vLines[i].split('\t');
						if(v.length==2){
							var sID=v[0], sPath=v[1];
							if(sID && sPath){
								xIDofPath[sID]=sPath;
								xPathOfID[sPath]=sID;
							}
						}
					}
				}

				//2013.3.29 enable bookmarks to work;
				var xIDofBkmk={};
				{
					var vLines=plugin.listBookmarks(-1).split('\r\n');
					for(var i in vLines){
						var v=vLines[i].split('\t');
						if(v.length>=2){
							var sBkmkID=v[0], sPath=v[1], sItemID=v[2];
							if(sBkmkID && sItemID){
								xIDofBkmk[sBkmkID]=sItemID;
							}
						}
					}
				}

				var _is_local_file=function(s){
					//2011.12.3 test if it's javascript, mailto, http://, or contains any of :?#;
					return s.match(/^javascript:/i)==null 
						&& s.match(/^mailto:/i)==null 
						&& s.match(/:\/\//i)==null 
						&& s.match(/[:\?\#]/i)==null
						//&& s.match(/[^\:\?\*\<\>\|\/\\]/)
						;
				};

				var _detect_linked_objs=function(s, sTag, vObjs){
					if(s && sTag){
						//2011.8.20 '\s' seems not to function within the [...] operator, so replace it with ' \t';

						//2012.7.30 consider all 3 possible formats of the linked objects;
						var vRE=[
							  '=\"(.+?)\"'				//src="abc def.jpg"
							, '=\'(.+?)\''				//src='abc def.jpg'
							//2013.11.2 this may produce some mismatches;
							//, '=(?!\"|\')(.+?)[> \t]'		//src=abc.jpg, spaces not allowed;
						];
						for(var i in vRE){
							var re=new RegExp(sTag+vRE[i], 'ig'), v=[];
							while(v=re.exec(s)){
								if(v && v.length>1){
									//2011.8.21 in case of empty filenames which would cause problems, like this: herf="" or src='';
									var sObj=v[1].replace(/[\'\"]/g, '');
									if(sObj && _is_local_file(sObj)){
										if(vObjs.indexOf(sObj)<0){
											vObjs.push(sObj);
										}
									}
								}
							}
						}
					}
				};

				var nDone=0, vInfoItems=[], vFails=[];
				var _act_on_treeitem=function(sSsgPath, iLevel){

					var xLI={}, sTitle=xNyf.getFolderHint(sSsgPath);

					var bContinue=plugin.ctrlProgressBar(sTitle||'Untitled', 1, true);
					if(!bContinue) return true;

					xLI['sSsgPath']=sSsgPath;
					xLI['sTitle']=sTitle;
					xLI['iLevel']=iLevel;
					xLI['sHref']='';
					xLI['vFiles']=[];
					xLI['nSub']=xNyf.getFolderCount(sSsgPath);
					xLI['nID']=plugin.getItemIDByPath(-1, sSsgPath)

					var xPath=new CLocalFile(sSsgPath); xPath.append('/');
					var sID=xPathOfID[xPath.toString()];

					var sRel='', vRel=plugin.listRelated(-1, sSsgPath);
					for(var i in vRel){
						var nID=plugin.getItemIDByPath(-1, vRel[i]);
						if(nID>=0){
							if(sRel) sRel+=';';
							sRel+=nID;
						}
					}
					xLI['sRelated']=sRel;

					var vFiles=xNyf.listFiles(sSsgPath), sDef=_default_name(vFiles);

					//first handle and export default content for the info item;
					if(sDef){
						var xSrc=new CLocalFile(sSsgPath); xSrc.append(sDef);
						if(!xNyf.isShortcut(xSrc)){
							if(sDef==sDefNoteFn){
								var sExt='.html', sName=_hash_name(xSrc, sTitle||'Untitled', sExt);
								var xDst=new CLocalFile(sDstDir); xDst.append(sName);
								if(_updated(xSrc, xDst)){
									var s=xNyf.loadText(xSrc);
									s=platform.convertRtfToHtml(s
										, {bInner: false
										, bPicture: true
										, sImgDir: sDstDir
										, sTitle: sTitle
										//, sFooter: (plugin.isAppLicensed() ? '' : 'Generated with myBase/HtmlTree Converter by Wjj Software')
										, sFooter: (plugin.isAppLicensed() ? '' : '%MYBASE-HTMLTREE-MAKER%')
										, sStyle: sCss
										, sJsFiles: 'jquery.js;itemlink.js'
										}
									);
									s=s.replace('%MYBASE-HTMLTREE-MAKER%', 'Generated with <a href="http://www.wjjsoft.com/cgi-bin/redir.cgi?ref=htmltree&q=mybase" target="_blank">myBase/HtmlTree Maker</a> by <a href="http://www.wjjsoft.com/cgi-bin/redir.cgi?ref=htmltree&q=home" target="_blank">Wjj Software</a>');
									xDst.saveUtf8(s);
								}
								xLI['sHref']=sName;
								if(sID) xIDofDoc[sID]=sName;
							}else{
								/*var sExt=xSrc.getExtension();
								var sName=_hash_name(xSrc, sTitle||'Untitled', sExt);
								var xDst=new CLocalFile(sDstDir); xDst.append(sName);
								if(_updated(xSrc, xDst)){
									if(xNyf.exportFile(xSrc, xDst)<0){
										sName='';
									}
								}*/
								var sExt=xSrc.getExtension(true);
								var sName=_hash_name(xSrc, sTitle||'Untitled', sExt);
								var xDst=new CLocalFile(sDstDir); xDst.append(sName);
								if(_updated(xSrc, xDst) && xNyf.exportFile(xSrc, xDst)>=0){
									if('.html;.htm'.split(';').indexOf(sExt.toLowerCase())>=0){
										var sHtml=xDst.loadText('auto');
										if(sHtml){
											var vObjs=[];
											_detect_linked_objs(sHtml, 'src', vObjs); //images
											_detect_linked_objs(sHtml, 'href', vObjs); //css
											if(vObjs.length>0){
												var xRE_Exts=new RegExp('(\.jpg|\.jpeg|\.gif|\.png|\.bmp|\.swf|\.css)', 'i');
												for(var i in vObjs){
													var sObj=vObjs[i]||'';
													if(sObj.match(xRE_Exts) && sObj.match(/[^:\?\*\|\/\\\<\>]/)){
														var xObjSrc=new CLocalFile(sSsgPath);
														try{
															//2013.11.2 For random names, this function may fail if any invalid characters contained;
															xObjSrc.append(sObj);
														}catch(e){
															//alert(e.toString());
															continue;
														}
														var sExt2=xObjSrc.getExtension(true);
														if(sExt2.toLowerCase()!='.js'){
															//2013.11.2 no js put into HTMLTREE;
															var sObjWinName=_hash_name(xSrc, sObj, sExt2);
															var xObjDst=new CLocalFile(sDstDir); xObjDst.append(sObjWinName);
															if(xNyf.exportFile(xObjSrc, xObjDst)>=0){
																var sPat=sObj.replace(/[\.\[\]]/g, function(w){return '\\'+w;});
																sHtml=sHtml.replace(new RegExp(sPat, 'g'), sObjWinName);
															}
														}
													}
												}
											}

											var sType=xDst.typeOfEncoding();
											if(sType=='ANSI'){
												xDst.saveAnsi(sHtml);
											}else{
												xDst.saveUtf8(sHtml);
											}
										}
									}
								}else{
									sName='';
								}

								xLI['sHref']=sName;
								if(sID) xIDofDoc[sID]=sName;
							}
						}
					}

					//2013.11.2 For now, just export linked images, instead of all existing attachments; See above;
					/*
					//then export image or CSS files linked with webpages;
					for(var i in vFiles){
						var sName=vFiles[i];
						if(sName!=sDef){
							var xSrc=new CLocalFile(sSsgPath); xSrc.append(sName);
							if(!xNyf.isShortcut(xSrc)){
								if('.gif;.jpg;.jpeg;.png;.bmp;.css'.split(';').indexOf(xSrc.getExtension().toLowerCase())>=0){
									var xDst=new CLocalFile(sDstDir); xDst.append(sName);
									if(_updated(xSrc, xDst)){
										if(xNyf.exportFile(xSrc, xDst)<0){
											sName='';
										}
									}
									if(sName){
										var v=xLI['vFiles']; v[v.length]=sName;
									}
								}
							}
						}
					}
					*/

					vInfoItems[vInfoItems.length]=xLI;

				};

				xNyf.traverseOutline(sCurItem, bCurBranch, _act_on_treeitem);

				if(vInfoItems.length>0){
					var sHtm='';
					for(var j in vInfoItems){
						var xLI=vInfoItems[j];

						var sAttach='';
						for(var i in xLI.vFiles){
							if(sAttach) sAttach+=';';
							sAttach+=xLI.vFiles[i];
						}

						if(sHtm) sHtm+='\r\n';

						var sID=xLI.nID>=0 ? xLI.nID : '', sSub=xLI.nSub>0 ? xLI.nSub : '';

						sHtm+='\t<li';
						sHtm+=' level=\"'+xLI.iLevel+'\"';
						if(sSub) sHtm+=' sub=\"'+sSub+'\"';
						if(sID) sHtm+=' id=\"'+sID+'\"';
						if(xLI.sRelated) sHtm+=' related=\"'+(xLI.sRelated||'')+'\"';
						if(xLI.sHref) sHtm+=' href=\"'+(xLI.sHref||'')+'\"';
						if(sAttach) sHtm+=' attach=\"'+sAttach+'\"';
						sHtm+='>';
						sHtm+=_html_encode(xLI.sTitle);
						sHtm+='</li>';
					}

					if(sHtm){
						var xFn=new CLocalFile(sDstDir); xFn.append('nav.html');
						var sHtml=xFn.loadText();
						xFn.saveUtf8(sHtml.replace(/%InfoItems%/, sHtm));
					}

					//2013.3.27 export IDs of info items, so the item link can work within web pages.
					var xFn=new CLocalFile(sDstDir); xFn.append('itemlink.js');
					var sTxt=xFn.loadText('auto');
					if(sTxt){
						//for item links;
						{
							var sTmp='';
							for(var sID in xIDofDoc){
								if(sTmp) sTmp+='\r\n\t, ';
								sTmp+='"'+sID+'": ';
								sTmp+='"'+xIDofDoc[sID]+'"';
							}
							sTmp='{'+sTmp+'}';
							sTxt=sTxt.replace(/%xItemIDs%/gi, sTmp);
						}
						//for bookmark links;
						{
							var sTmp='';
							for(var sBkmkID in xIDofBkmk){
								if(sTmp) sTmp+='\r\n\t, ';
								sTmp+='"'+sBkmkID+'": ';
								sTmp+='"'+xIDofBkmk[sBkmkID]+'"';
							}
							sTmp='{'+sTmp+'}';
							sTxt=sTxt.replace(/%xBkmkIDs%/gi, sTmp);
						}
						xFn.saveUtf8(sTxt);
					}

					if(confirm(_lc2('Done', 'The HTML tree successfully generated. View it now?'))){
						var xStartPage=new CLocalFile(sDstDir); xStartPage.append('index.html');
						xStartPage.launch('open');
					}
				}
			}
		}

	}else{
		alert(_lc('Prompt.Warn.NoDbOpened', 'No database is currently opened.'));
	}

}catch(e){
	alert(e);
}
